/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  deux_barriere_sequence_1.INO
   Document : Dossier barrière de parking (D-APARK)
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur	Variable Arduino	Broche AutoProg Uno

Bouton poussoir/RFID       bouton_poussoir                A4
Récepteur infrarouge	   recepteur_IR                   A5
Fin de course fermeture	   fdc_fermeture	          3
Fin de course ouverture	   fdc_ouverture	          2


Module actionneur	Variable Arduino	Broche AutoProg Uno

Module Gyrophare	    gyrophare	                  4
Emetteur infrarouge	    emetteur_IR                   5
Moteur                        moteur                      6
LCD                            OLED                       7
ouverture/fermeture		

------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque
#include <IRremote.h>//La bibliothèque doit être copié dans le dossier librairies du logiciel Arduino
#include <AXE133Y.h>//bibliothèque OLED

//Définition des variables, constantes et pin :

byte nb_place = 10;
// Pin d'entrée

const int fdc_fermeture_A   = 3; 
const int fdc_ouverture_A   = 2; 
const int bouton_poussoir_A = A4;
const int recepteur_IR_A    = A5;

const int fdc_fermeture_B   = A2; 
const int fdc_ouverture_B   = A3; 
const int bouton_poussoir_B = A0;
const int recepteur_IR_B    = A1;

//Pin de sorties
const int gyrophare_A     = 4; 
const int emetteur_IR_A   = 5; 
const int moteur_A        = 6; 
const int oled            = 7;
const int gyrophare_B     = 4; 
const int emetteur_IR_B   = 5; 
const int moteur_B        = 6;

AXE133Y OLED = AXE133Y(oled);//Affectation du pin de l'écran OLED

//Initialisation

void setup()
{
    //paramètrage des pins en entrée/sortie
    
    // Définition des pins comme des entrées

    pinMode (fdc_fermeture_A, INPUT);
    pinMode (fdc_ouverture_A, INPUT);
    pinMode (bouton_poussoir_A, INPUT);
    pinMode (recepteur_IR_A, INPUT);
    pinMode (fdc_fermeture_B, INPUT);
    pinMode (fdc_ouverture_B, INPUT);
    pinMode (bouton_poussoir_B, INPUT);
    pinMode (recepteur_IR_B, INPUT);
    
    // Définition des pins comme des sorties
    pinMode (gyrophare_A, OUTPUT);
    pinMode (moteur_A, OUTPUT);
    pinMode (gyrophare_B, OUTPUT);
    pinMode (moteur_B, OUTPUT);
    pinMode (emetteur_IR_A, OUTPUT);
    pinMode (emetteur_IR_B, OUTPUT);   

    
    OLED.cursorPosition(1,0);//Initialisation du texte du Parking
    OLED.print("Parking Ouvert");
    OLED.cursorPosition(2,0);
    OLED.print("A4 Technologie");    
    
    
    
    
}



//Programme principal

//Boucle infinie
void loop()
{
 
 digitalWrite(emetteur_IR_A,HIGH); // Activation de la barrière infrarouge A
 digitalWrite(emetteur_IR_B,HIGH); // Activation de la barrière infrarouge B
 
 fermeture_barriere_A();
 fermeture_barriere_B();
 
 OLED.clearScreen();
 OLED.cursorPosition(1,0);//Initialisation du texte du Parking
 OLED.print("Parking ouvert");
 OLED.cursorPosition(2,0);
 OLED.print("A4 Technologie");
 
 if (nb_place=0)
  {   
       OLED.cursorPosition(1,0);//Initialisation du texte du Parking
       OLED.print("Parking plein");
       OLED.cursorPosition(2,0);
       OLED.print("Aucune place");
  }
 
 else if (nb_place=10 && digitalRead(bouton_poussoir_B)==HIGH)
 {
       OLED.cursorPosition(1,0);//Initialisation du texte du Parking
       OLED.print("Erreur");
       OLED.cursorPosition(2,0);
       OLED.print("Parking Libre");
 }      
   
 else if (digitalRead(bouton_poussoir_A)==HIGH)   
   { 
       ouverture_barriere_A();//Aller dans la fonction ouverture_barriere
       
       nb_place = nb_place - 1;
       
       OLED.cursorPosition(1,0);//Initialisation du texte du Parking
       OLED.print("Parking ouvert");
       OLED.cursorPosition(2,0);
       OLED.print(String(nb_place));
       OLED.print(" places");
       
       if (digitalRead(recepteur_IR_A)==HIGH)
       {
         fermeture_barriere_A();
       }
   }
 else if (digitalRead(bouton_poussoir_B)==HIGH)
    { 
       ouverture_barriere_B();//Aller dans la fonction ouverture_barriere
       
       nb_place = nb_place + 1;
       
       OLED.cursorPosition(1,0);//Initialisation du texte du Parking
       OLED.print("Parking ouvert");
       OLED.cursorPosition(2,0);
       OLED.print(String(nb_place));
       OLED.print(" places");
       
       if (digitalRead(recepteur_IR_B)==HIGH)
       {
         fermeture_barriere_B();
       }
   }
}   

// Fin du Programme principal

// Fonctions

void ouverture_barriere_A()// Fonction ouverture de la barriere A
{
       while (digitalRead(fdc_ouverture_A)==LOW)// exécuter les commandes tant que fdc_ouverture est désactivé  
     {
       digitalWrite(moteur_A,HIGH);// Marche du moteur (ouverture de la barrière
       digitalWrite(gyrophare_A,HIGH);// Activation du gyrophare
       delay(100);
       digitalWrite(gyrophare_A,LOW);// Désactivation du gyrophare
       delay(100);       
     }
     digitalWrite(moteur_A,LOW); // Arrêt du moteur
}     

void fermeture_barriere_A()// Fonction fermeture de la barriere A
{
       while (digitalRead(fdc_fermeture_A)==LOW) // exécuter les commandes tant que fdc_fermeture est désactivé 
     {
         while (digitalRead(recepteur_IR_A)==HIGH)// Tant que la détection infrarouge est activée
         {
           digitalWrite(moteur_A,LOW); // Arrêt du moteur
           delay (500);
         }     
       digitalWrite(moteur_A,HIGH); // Marche du moteur (fermeture de la barrière)
       digitalWrite(gyrophare_A,HIGH);// Activation du gyrophare
       delay(100);
       digitalWrite(gyrophare_A,LOW);// Désactivation du gyrophare
       delay(100);     
      
     }
        digitalWrite(moteur_A,LOW); // Arrêt du moteur
}

void ouverture_barriere_B()// Fonction ouverture de la barriere B
{
       while (digitalRead(fdc_ouverture_B)==LOW)// exécuter les commandes tant que fdc_ouverture est désactivé  
     {
       digitalWrite(moteur_B,HIGH);// Marche du moteur (ouverture de la barrière
       digitalWrite(gyrophare_B,HIGH);// Activation du gyrophare
       delay(100);
       digitalWrite(gyrophare_B,LOW);// Désactivation du gyrophare
       delay(100);       
     }
     digitalWrite(moteur_B,LOW); // Arrêt du moteur
}     

void fermeture_barriere_B()// Fonction fermeture de la barriere B
{
       while (digitalRead(fdc_fermeture_B)==LOW) // exécuter les commandes tant que fdc_fermeture est désactivé 
     {
         while (digitalRead(recepteur_IR_B)==HIGH)// Tant que la détection infrarouge est activée
         {
           digitalWrite(moteur_B,LOW); // Arrêt du moteur
           delay (500);
         }     
       digitalWrite(moteur_B,HIGH); // Marche du moteur (fermeture de la barrière)
       digitalWrite(gyrophare_B,HIGH);// Activation du gyrophare
       delay(100);
       digitalWrite(gyrophare_B,LOW);// Désactivation du gyrophare
       delay(100);     
      
     }
        digitalWrite(moteur_B,LOW); // Arrêt du moteur
}


